load("@bazel_skylib//lib:collections.bzl", "collections")
load("@fbcode_macros//build_defs:python_testslide.bzl", "python_testslide")
load("@fbsource//tools/build_defs:testpilot_defs.bzl", "special_tags")

def botorch_test_cpu(
        name,
        srcs = [],
        deps = [],
        **kwargs):
    """Creates target for running botorch tests on CPU"""

    python_testslide(
        name = name,
        srcs = [s for s in srcs if s != "test/test_cuda.py"],
        deps = deps,
        **kwargs
    )

def botorch_test_cuda(
        name,
        srcs = [],
        deps = [],
        **kwargs):
    """Creates target for running botorch tests on GPU using remote execution"""

    python_testslide(
        name = name,
        srcs = collections.uniq(srcs + ["test/test_cuda.py"]),
        deps = deps,
        tags = [
            special_tags.long_running,
            special_tags.run_as_bundle,
            "re_opts_capabilities={\"platform\": \"gpu-remote-execution\", \"subplatform\": \"P100\"}",
            "supports_remote_execution",
        ],
        **kwargs
    )
